<?php
require_once __DIR__ . '/rotator_panel/functions.php';

// ambil semua domain aktif
$sql = "
    SELECT d.id,d.domain
    FROM " . TBL_DOMAINS . " d
    WHERE d.is_active=1
";
$res = $mysqli->query($sql);
if (!$res) {
    echo "DB error: " . $mysqli->error . PHP_EOL;
    exit;
}

$checked = 0;

while ($row = $res->fetch_assoc()) {
    $id = (int)$row['id'];
    $domain = $row['domain'];

    $result = check_trustpositif($domain);
    $blocked = ($result['blocked'] === true) ? 1 : 0;
    $info    = $result['message'] ?? '';

    $stmt = $mysqli->prepare("
        UPDATE " . TBL_DOMAINS . "
        SET is_blocked=?, last_check_at=NOW(), last_check_result=?
        WHERE id=?
    ");
    $stmt->bind_param('isi', $blocked, $info, $id);
    $stmt->execute();
    $stmt->close();

    $checked++;
}

echo "Done. Checked {$checked} domain(s) at ".date('Y-m-d H:i:s')." WIB\n";
