<?php
require_once __DIR__ . '/rotator_panel/functions.php';

// slug dari URL, contoh /harimau -> k=harimau
$key = $_GET['k'] ?? '';
$key = trim($key);
if ($key === '') {
    http_response_code(404);
    echo "Rotator not found.";
    exit;
}

// cari rotator sesuai slug
$stmt = $mysqli->prepare("SELECT * FROM " . TBL_ROTATORS . " WHERE slug=? LIMIT 1");
$stmt->bind_param('s', $key);
$stmt->execute();
$res = $stmt->get_result();
$rot = $res->fetch_assoc();
$stmt->close();

if (!$rot) {
    http_response_code(404);
    echo "Rotator not found.";
    exit;
}

$rid = (int)$rot['id'];

// ambil domain aktif
$stmt = $mysqli->prepare("
    SELECT * FROM " . TBL_DOMAINS . "
    WHERE rotator_id=? AND is_active=1
    ORDER BY position ASC
");
$stmt->bind_param('i', $rid);
$stmt->execute();
$res = $stmt->get_result();
$domains = [];
while ($row = $res->fetch_assoc()) $domains[] = $row;
$stmt->close();

if (empty($domains)) {
    notify_rotator_owner($rot,
        "⚠️ <b>Rotator kosong</b>\n".
        "Rotator: <b>{$rot['name']}</b> (slug: <code>{$rot['slug']}</code>)\n".
        "Tidak ada domain aktif.\n".
        "Waktu: " . date('Y-m-d H:i:s') . " WIB"
    );
    http_response_code(503);
    echo "Rotator belum disiapkan.";
    exit;
}

// domain pertama (prioritas 1)
$first = $domains[0];
$firstBlocked = (int)$first['is_blocked'] === 1;
$firstDomain  = $first['domain'];

// domain yang tidak terblokir
$unblocked = [];
foreach ($domains as $d) {
    if ((int)$d['is_blocked'] === 0) $unblocked[] = $d;
}

// kalau semua blocked
if (empty($unblocked)) {
    notify_rotator_owner($rot,
        "⛔ <b>Semua domain blocked</b>\n".
        "Rotator: <b>{$rot['name']}</b> (slug: <code>{$rot['slug']}</code>)\n".
        "Domain 1: {$firstDomain}\n".
        "Info: {$first['last_check_result']}\n".
        "Waktu: " . date('Y-m-d H:i:s') . " WIB"
    );
    http_response_code(503);
    echo "Semua domain rotator ini ditandai terblokir. Hubungi admin.";
    exit;
}

// pilih target
if ($rot['rotation_mode'] === 'random') {
    shuffle($unblocked);
    $target = $unblocked[0];
} else {
    // priority: berdasarkan posisi terkecil
    usort($unblocked, function($a,$b){
        return (int)$a['position'] <=> (int)$b['position'];
    });
    $target = $unblocked[0];
}

$targetDomain = $target['domain'];

// cek apakah perlu kirim "switch"
$last_active = get_rotator_setting($rid, 'last_active_domain', '');
if ($last_active !== $targetDomain) {

    // buat laporan status 3 domain
    $lines = [];
    foreach ($domains as $d) {
        $status = $d['is_blocked'] ? '⛔ Blocked' : '✅ Aman';
        $lines[] = "Domain {$d['position']}: {$d['domain']} — {$status}";
    }
    $statusText = implode("\n", $lines);

    $msg  = "🔁 <b>Rotator Switch</b>\n";
    $msg .= "Rotator: <b>{$rot['name']}</b> (slug: <code>{$rot['slug']}</code>)\n\n";
    $msg .= $statusText . "\n\n";
    $msg .= "Domain aktif saat ini: ✅ <a href=\"https://{$targetDomain}\">{$targetDomain}</a>\n";
    $msg .= "Waktu: " . date('Y-m-d H:i:s') . " WIB";

    notify_rotator_owner($rot, $msg);
    set_rotator_setting($rid, 'last_active_domain', $targetDomain);
}

// redirect
$target_url = $targetDomain;
if (!preg_match('#^https?://#i', $target_url)) {
    $target_url = 'https://' . $target_url;
}

$request_uri = $_SERVER['REQUEST_URI'] ?? '/';
$script_name = basename(__FILE__);

if (strpos($request_uri, $script_name) !== false) {
    $request_uri = '/';
}

$target_url = rtrim($target_url, '/') . $request_uri;

header('Location: ' . $target_url, true, 302);
exit;
