<?php
require_once __DIR__ . '/functions.php';

// =======================
// CSRF
// =======================
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf = $_SESSION['csrf_token'];

function check_csrf() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $t = $_POST['csrf_token'] ?? '';
        if (!$t || !hash_equals($_SESSION['csrf_token'] ?? '', $t)) {
            http_response_code(403);
            die('Invalid CSRF token');
        }
    }
}
check_csrf();

$message = '';
$message_type = 'info';

// cek apakah sudah ada user
$res = $mysqli->query("SELECT COUNT(*) AS c FROM " . TBL_USERS);
$row = $res->fetch_assoc();
$has_user = $row['c'] > 0;

// =======================
// HANDLE POST
// =======================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // ---- Setup admin pertama ----
    if (!$has_user && $action === 'setup_admin') {
        $u = trim($_POST['username'] ?? '');
        $p = $_POST['password'] ?? '';
        $p2 = $_POST['password2'] ?? '';
        if ($u === '' || $p === '' || $p !== $p2) {
            $message = 'Username kosong atau password tidak sama.';
            $message_type = 'error';
        } else {
            $hash = password_hash($p, PASSWORD_BCRYPT);
            $stmt = $mysqli->prepare("
                INSERT INTO " . TBL_USERS . " (username,password_hash,is_super)
                VALUES(?,?,1)
            ");
            $stmt->bind_param('ss', $u, $hash);
            if ($stmt->execute()) {
                $has_user = true;
                $message = 'Admin master dibuat. Silakan login.';
                $message_type = 'success';
            } else {
                $message = 'Gagal membuat admin: ' . $stmt->error;
                $message_type = 'error';
            }
            $stmt->close();
        }
    }

    // ---- Login ----
    elseif ($has_user && $action === 'login') {
        $u = trim($_POST['username'] ?? '');
        $p = $_POST['password'] ?? '';
        $stmt = $mysqli->prepare("SELECT id,password_hash FROM " . TBL_USERS . " WHERE username=? LIMIT 1");
        $stmt->bind_param('s', $u);
        $stmt->execute();
        $stmt->bind_result($id, $hash);
        if ($stmt->fetch() && password_verify($p, $hash)) {
            session_regenerate_id(true);
            $_SESSION['uid'] = $id;
            $message = 'Login sukses.';
            $message_type = 'success';
        } else {
            $message = 'Username / password salah.';
            $message_type = 'error';
        }
        $stmt->close();
    }

    // ---- Logout ----
    elseif ($action === 'logout') {
        session_destroy();
        header('Location: admin.php');
        exit;
    }

    // ---- Hanya kalau sudah login ----
    elseif (get_current_user_row()) {
        $me = get_current_user_row();
        $is_super = (int)$me['is_super'];

        // Tambah user (super admin saja)
        if ($is_super && $action === 'add_user') {
            $u = trim($_POST['username'] ?? '');
            $p = $_POST['password'] ?? '';
            $p2 = $_POST['password2'] ?? '';
            $super = !empty($_POST['is_super']) ? 1 : 0;

            if ($u === '' || $p === '' || $p !== $p2) {
                $message = 'Username kosong atau password tidak sama.';
                $message_type = 'error';
            } else {
                $hash = password_hash($p, PASSWORD_BCRYPT);
                $stmt = $mysqli->prepare("
                    INSERT INTO " . TBL_USERS . " (username,password_hash,is_super)
                    VALUES(?,?,?)
                ");
                $stmt->bind_param('ssi', $u, $hash, $super);
                if ($stmt->execute()) {
                    $message = 'User baru dibuat.';
                    $message_type = 'success';
                } else {
                    $message = 'Gagal membuat user: ' . $stmt->error;
                    $message_type = 'error';
                }
                $stmt->close();
            }
        }

        // Update Telegram user (super admin)
        elseif ($is_super && $action === 'update_user_telegram') {
            $uid  = (int)($_POST['user_id'] ?? 0);
            $chat = trim($_POST['telegram_chat_id'] ?? '');
            $notif = !empty($_POST['notify_enabled']) ? 1 : 0;
            if ($uid > 0) {
                $stmt = $mysqli->prepare("
                    UPDATE " . TBL_USERS . "
                    SET telegram_chat_id=?, notify_enabled=?
                    WHERE id=?
                ");
                $stmt->bind_param('sii', $chat, $notif, $uid);
                $stmt->execute();
                $stmt->close();
                $message = 'Data Telegram user diperbarui.';
                $message_type = 'success';
            }
        }

        // Ganti password user (super admin)
        elseif ($is_super && $action === 'change_user_password') {
            $uid = (int)($_POST['user_id'] ?? 0);
            $p = $_POST['new_password'] ?? '';
            $p2 = $_POST['new_password2'] ?? '';
            if ($uid && $p !== '' && $p === $p2) {
                $hash = password_hash($p, PASSWORD_BCRYPT);
                $stmt = $mysqli->prepare("
                    UPDATE " . TBL_USERS . " SET password_hash=? WHERE id=?
                ");
                $stmt->bind_param('si', $hash, $uid);
                $stmt->execute();
                $stmt->close();
                $message = 'Password user diupdate.';
                $message_type = 'success';
            } else {
                $message = 'Password kosong / tidak sama.';
                $message_type = 'error';
            }
        }

        // Tambah rotator
        elseif ($action === 'add_rotator') {
            $name = trim($_POST['name'] ?? '');
            $slug = trim($_POST['slug'] ?? '');
            if ($name === '' || $slug === '') {
                $message = 'Nama & slug tidak boleh kosong.';
                $message_type = 'error';
            } else {
                // slug: huruf angka strip
                $slug = strtolower(preg_replace('/[^a-z0-9_-]/i', '', $slug));
                if ($slug === '') {
                    $message = 'Slug tidak valid.';
                    $message_type = 'error';
                } else {
                    $owner_id = $me['id'];
                    // super admin boleh pilih owner lain
                    if ($is_super && !empty($_POST['owner_id'])) {
                        $owner_id = (int)$_POST['owner_id'];
                    }

                    $stmt = $mysqli->prepare("
                        INSERT INTO " . TBL_ROTATORS . " (user_id,name,slug)
                        VALUES(?,?,?)
                    ");
                    $stmt->bind_param('iss', $owner_id, $name, $slug);
                    if ($stmt->execute()) {
                        $message = 'Rotator baru dibuat.';
                        $message_type = 'success';
                    } else {
                        $message = 'Gagal membuat rotator: ' . $stmt->error;
                        $message_type = 'error';
                    }
                    $stmt->close();
                }
            }
        }

        // Hapus rotator
        elseif ($action === 'delete_rotator') {
            $rid = (int)($_POST['rotator_id'] ?? 0);
            if ($rid > 0) {
                // cek kepemilikan
                if ($is_super) {
                    $stmt = $mysqli->prepare("DELETE FROM " . TBL_ROTATORS . " WHERE id=?");
                    $stmt->bind_param('i', $rid);
                } else {
                    $stmt = $mysqli->prepare("DELETE FROM " . TBL_ROTATORS . " WHERE id=? AND user_id=?");
                    $stmt->bind_param('ii', $rid, $me['id']);
                }
                $stmt->execute();
                $stmt->close();
                $message = 'Rotator dihapus.';
                $message_type = 'success';
            }
        }

        // Simpan domain rotator
        elseif ($action === 'save_domains') {
            $rid = (int)($_POST['rotator_id'] ?? 0);
            if ($rid > 0) {
                // cek kepemilikan
                if (!$is_super) {
                    $stmt = $mysqli->prepare("SELECT id FROM " . TBL_ROTATORS . " WHERE id=? AND user_id=?");
                    $stmt->bind_param('ii', $rid, $me['id']);
                    $stmt->execute();
                    $res = $stmt->get_result();
                    $ok = (bool)$res->fetch_assoc();
                    $stmt->close();
                    if (!$ok) {
                        $message = 'Anda tidak punya akses rotator ini.';
                        $message_type = 'error';
                        goto after_post;
                    }
                }

                for ($pos = 1; $pos <= 3; $pos++) {
                    $field = "domain{$pos}";
                    $activeField = "active{$pos}";
                    $domain = trim($_POST[$field] ?? '');
                    $active = !empty($_POST[$activeField]) ? 1 : 0;

                    if ($domain === '') {
                        // hapus row jika ada
                        $stmt = $mysqli->prepare("DELETE FROM " . TBL_DOMAINS . " WHERE rotator_id=? AND position=?");
                        $stmt->bind_param('ii', $rid, $pos);
                        $stmt->execute();
                        $stmt->close();
                        continue;
                    }

                    $domain = preg_replace('#^https?://#i', '', $domain);

                    $stmt = $mysqli->prepare("
                        INSERT INTO " . TBL_DOMAINS . " (rotator_id,position,domain,is_active)
                        VALUES(?,?,?,?)
                        ON DUPLICATE KEY UPDATE domain=VALUES(domain), is_active=VALUES(is_active)
                    ");
                    $stmt->bind_param('iisi', $rid, $pos, $domain, $active);
                    $stmt->execute();
                    $stmt->close();
                }

                $message = 'Domain rotator disimpan.';
                $message_type = 'success';
            }
        }

        // Ubah mode rotasi
        elseif ($action === 'update_mode') {
            $rid = (int)($_POST['rotator_id'] ?? 0);
            $mode = $_POST['rotation_mode'] ?? 'priority';
            if (!in_array($mode, ['random','priority'], true)) {
                $mode = 'priority';
            }
            if ($rid > 0) {
                if ($is_super) {
                    $stmt = $mysqli->prepare("UPDATE " . TBL_ROTATORS . " SET rotation_mode=? WHERE id=?");
                    $stmt->bind_param('si', $mode, $rid);
                } else {
                    $stmt = $mysqli->prepare("UPDATE " . TBL_ROTATORS . " SET rotation_mode=? WHERE id=? AND user_id=?");
                    $stmt->bind_param('sii', $mode, $rid, $me['id']);
                }
                $stmt->execute();
                $stmt->close();
                $message = 'Mode rotasi diupdate.';
                $message_type = 'success';
            }
        }

        // Manual cek Nawala satu domain
        elseif ($action === 'check_nawala') {
            $did = (int)($_POST['domain_id'] ?? 0);
            if ($did > 0) {
                $stmt = $mysqli->prepare("
                    SELECT d.id,d.domain,d.rotator_id,r.user_id
                    FROM " . TBL_DOMAINS . " d
                    JOIN " . TBL_ROTATORS . " r ON d.rotator_id=r.id
                    WHERE d.id=?
                ");
                $stmt->bind_param('i', $did);
                $stmt->execute();
                $res = $stmt->get_result();
                $row = $res->fetch_assoc();
                $stmt->close();

                if (!$row) {
                    $message = 'Domain tidak ditemukan.';
                    $message_type = 'error';
                } elseif (!$is_super && $row['user_id'] != $me['id']) {
                    $message = 'Tidak punya akses domain ini.';
                    $message_type = 'error';
                } else {
                    $result = check_trustpositif($row['domain']);
                    $blocked = ($result['blocked'] === true) ? 1 : 0;
                    $info = $result['message'] ?? '';

                    $stmt = $mysqli->prepare("
                        UPDATE " . TBL_DOMAINS . "
                        SET is_blocked=?, last_check_at=NOW(), last_check_result=?
                        WHERE id=?
                    ");
                    $stmt->bind_param('isi', $blocked, $info, $did);
                    $stmt->execute();
                    $stmt->close();

                    $message = 'Cek Nawala: ' . $info;
                    $message_type = $blocked ? 'error' : 'success';
                }
            }
        }
    }
}
after_post:

// =======================
// DATA UNTUK VIEW
// =======================
$me = get_current_user_row();
$is_super = $me ? (int)$me['is_super'] : 0;

// list users (untuk super admin)
$all_users = [];
if ($is_super) {
    $res = $mysqli->query("SELECT * FROM " . TBL_USERS . " ORDER BY id ASC");
    while ($r = $res->fetch_assoc()) $all_users[] = $r;
}

// list rotator milik user (super admin lihat semua)
$my_rotators = [];
if ($me) {
    if ($is_super) {
        $sql = "
          SELECT r.*, u.username
          FROM " . TBL_ROTATORS . " r
          JOIN " . TBL_USERS . " u ON r.user_id=u.id
          ORDER BY r.id ASC
        ";
        $res = $mysqli->query($sql);
    } else {
        $stmt = $mysqli->prepare("
          SELECT r.*, u.username
          FROM " . TBL_ROTATORS . " r
          JOIN " . TBL_USERS . " u ON r.user_id=u.id
          WHERE r.user_id=?
          ORDER BY r.id ASC
        ");
        $stmt->bind_param('i', $me['id']);
        $stmt->execute();
        $res = $stmt->get_result();
    }
    while ($r = $res->fetch_assoc()) $my_rotators[] = $r;
    if (isset($stmt)) $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Rotator Panel</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
    :root {
        --bg:#020617;
        --card:#020617;
        --accent:#38bdf8;
        --border:#1f2937;
        --text:#e5e7eb;
        --muted:#9ca3af;
        --danger:#f97373;
        --success:#22c55e;
    }
    *{box-sizing:border-box;}
    body{
        margin:0;
        font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif;
        background:radial-gradient(circle at top,#0b1120 0,#020617 55%);
        color:var(--text);
    }
    .layout{
        min-height:100vh;
        display:flex;
        align-items:center;
        justify-content:center;
        padding:24px 12px;
    }
    .panel{
        width:100%;
        max-width:1100px;
        background:radial-gradient(circle at top left,#0f172a 0,#020617 55%);
        border-radius:24px;
        border:1px solid rgba(148,163,184,0.35);
        padding:22px 22px 20px;
        box-shadow:0 26px 60px rgba(0,0,0,0.85);
        position:relative;
        overflow:hidden;
    }
    .panel-inner{position:relative;z-index:2;}
    h1{
        margin:0 0 4px;
        font-size:1.6rem;
        display:flex;
        align-items:center;
        gap:10px;
    }
    .logo-pill{
        width:30px;height:30px;border-radius:999px;
        background:radial-gradient(circle at 20% 0,#38bdf8,#0ea5e9 40%,#4f46e5 100%);
        display:flex;align-items:center;justify-content:center;
        font-size:15px;font-weight:700;color:#020617;
        box-shadow:0 0 0 1px rgba(15,23,42,0.8),0 0 24px rgba(56,189,248,0.7);
    }
    .subtitle{font-size:0.86rem;color:var(--muted);}
    .topbar{
        display:flex;justify-content:space-between;align-items:flex-start;
        gap:12px;margin-bottom:10px;
    }
    .badge{
        padding:4px 10px;border-radius:999px;font-size:0.7rem;
        background:rgba(56,189,248,0.12);color:var(--accent);
        border:1px solid rgba(56,189,248,0.4);
    }
    .btn{
        border-radius:999px;border:1px solid transparent;
        padding:7px 14px;font-size:0.78rem;font-weight:500;
        cursor:pointer;display:inline-flex;align-items:center;gap:6px;
        background:transparent;color:var(--muted);
    }
    .btn-primary{
        background:linear-gradient(135deg,#38bdf8,#0ea5e9);
        color:#020617;box-shadow:0 12px 30px rgba(56,189,248,0.38);
    }
    .btn-outline{border-color:var(--border);}
    .btn-danger{
        background:rgba(248,113,113,0.12);color:#fecaca;
        border-color:rgba(248,113,113,0.5);
    }
    .btn-small{padding:5px 10px;font-size:0.72rem;}
    .field{margin-bottom:8px;}
    label{display:block;font-size:0.78rem;margin-bottom:3px;color:var(--muted);}
    input[type="text"],input[type="password"],select{
        width:100%;border-radius:10px;border:1px solid var(--border);
        padding:7px 10px;background:#020617;color:var(--text);font-size:0.86rem;
    }
    input:focus,select:focus{outline:none;border-color:var(--accent);}
    .message{
        margin:10px 0 14px;padding:8px 11px;border-radius:12px;font-size:0.8rem;
    }
    .message.info{background:rgba(148,163,184,0.12);color:var(--muted);}
    .message.success{
        background:rgba(34,197,94,0.14);color:#bbf7d0;
        border:1px solid rgba(34,197,94,0.4);
    }
    .message.error{
        background:rgba(248,113,113,0.14);color:#fecaca;
        border:1px solid rgba(248,113,113,0.4);
    }
    .grid{display:grid;grid-template-columns:minmax(0,1.6fr) minmax(0,1fr);gap:18px;margin-top:12px;}
    @media(max-width:900px){.grid{grid-template-columns:1fr;}}
    .card{
        border-radius:16px;border:1px solid rgba(51,65,85,0.9);
        padding:10px 11px 10px;background:rgba(15,23,42,0.96);
        margin-bottom:10px;
    }
    .card-title{font-size:0.9rem;font-weight:600;margin-bottom:6px;}
    .caption{font-size:0.75rem;color:var(--muted);}
    .domain-row{border-top:1px solid rgba(31,41,55,0.9);padding-top:6px;margin-top:6px;}
    .status-pill{
        display:inline-flex;align-items:center;gap:4px;
        padding:2px 8px;border-radius:999px;font-size:0.7rem;
    }
    .st-on{background:rgba(34,197,94,0.15);color:#bbf7d0;}
    .st-off{background:rgba(148,163,184,0.16);color:#e5e7eb;}
    .st-block{background:rgba(248,113,113,0.16);color:#fecaca;}
    .st-safe{background:rgba(34,197,94,0.16);color:#bbf7d0;}
    .st-unknown{background:rgba(148,163,184,0.18);color:#e5e7eb;}
    table{border-collapse:collapse;width:100%;font-size:0.78rem;}
    th,td{padding:4px 4px;}
    th{text-align:left;border-bottom:1px solid rgba(31,41,55,0.9);}
    tr+tr td{border-top:1px solid rgba(31,41,55,0.4);}
</style>
</head>
<body>
<div class="layout">
<div class="panel">
<div class="panel-inner">

    <div class="topbar">
        <div>
            <h1><span class="logo-pill">R</span> Rotator Panel</h1>
            <div class="subtitle">Multi rotator + multi user + cek blokir Nawala.</div>
        </div>
        <div style="text-align:right;font-size:0.75rem;">
            <div class="badge">PHP + MySQL ready</div><br>
            <?php if ($me): ?>
                <span>Login sebagai <strong><?=h($me['username'])?></strong> <?= $is_super ? '(super)' : '' ?></span>
                <form method="post" style="display:inline;">
                    <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                    <input type="hidden" name="action" value="logout">
                    <button class="btn btn-outline btn-small" type="submit">Logout</button>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($message): ?>
        <div class="message <?=$message_type?>"><?=h($message)?></div>
    <?php endif; ?>

    <?php if (!$has_user): ?>
        <!-- Setup admin pertama -->
        <div class="card" style="max-width:380px;margin:0 auto;">
            <div class="card-title">Setup Admin Master</div>
            <p class="caption">Belum ada user. Buat akun admin pertama.</p>
            <form method="post">
                <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                <input type="hidden" name="action" value="setup_admin">
                <div class="field">
                    <label>Username</label>
                    <input type="text" name="username" autocomplete="off" required>
                </div>
                <div class="field">
                    <label>Password</label>
                    <input type="password" name="password" required>
                </div>
                <div class="field">
                    <label>Ulangi Password</label>
                    <input type="password" name="password2" required>
                </div>
                <button class="btn btn-primary" type="submit">Buat Admin</button>
            </form>
        </div>

    <?php elseif (!$me): ?>
        <!-- Form login -->
        <div class="card" style="max-width:380px;margin:0 auto;">
            <div class="card-title">Login Admin</div>
            <form method="post">
                <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                <input type="hidden" name="action" value="login">
                <div class="field">
                    <label>Username</label>
                    <input type="text" name="username" autocomplete="username" required>
                </div>
                <div class="field">
                    <label>Password</label>
                    <input type="password" name="password" autocomplete="current-password" required>
                </div>
                <button class="btn btn-primary" type="submit">Login</button>
            </form>
            <p class="caption" style="margin-top:8px;">Gunakan HTTPS & batasi IP panel untuk keamanan tambahan.</p>
        </div>

    <?php else: ?>
        <!-- MAIN PANEL -->
        <div class="grid">

            <!-- KIRI: Rotator & Domain -->
            <div>
                <div class="card">
                    <div class="card-title">Buat Rotator Baru</div>
                    <form method="post" style="display:grid;grid-template-columns:1fr 1fr;gap:8px;">
                        <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                        <input type="hidden" name="action" value="add_rotator">
                        <div class="field">
                            <label>Nama Rotator (brand)</label>
                            <input type="text" name="name" placeholder="Contoh: Harimau">
                        </div>
                        <div class="field">
                            <label>Slug URL</label>
                            <input type="text" name="slug" placeholder="Contoh: harimau (hasil: /harimau)">
                        </div>
                        <?php if ($is_super): ?>
                            <div class="field">
                                <label>Owner (user)</label>
                                <select name="owner_id">
                                    <?php foreach ($all_users as $u): ?>
                                        <option value="<?=$u['id']?>"><?=h($u['username'])?><?=$u['is_super']?' (super)':''?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        <?php endif; ?>
                        <div style="align-self:end;">
                            <button class="btn btn-primary btn-small" type="submit">Tambah Rotator</button>
                        </div>
                    </form>
                    <p class="caption" style="margin-top:6px;">URL rotator: <code>https://jalurvipp.site/&lt;slug&gt;</code></p>
                </div>

                <?php if (empty($my_rotators)): ?>
                    <div class="card">
                        <div class="caption">Belum ada rotator. Tambahkan di atas.</div>
                    </div>
                <?php else: ?>
                    <?php foreach ($my_rotators as $rot): ?>
                        <?php
                        $rid = (int)$rot['id'];
                        // ambil domain rotator
                        $stmt = $mysqli->prepare("SELECT * FROM " . TBL_DOMAINS . " WHERE rotator_id=? ORDER BY position ASC");
                        $stmt->bind_param('i', $rid);
                        $stmt->execute();
                        $res = $stmt->get_result();
                        $domains = [1=>null,2=>null,3=>null];
                        while ($d = $res->fetch_assoc()) {
                            $domains[(int)$d['position']] = $d;
                        }
                        $stmt->close();
                        ?>
                        <div class="card">
                            <div class="card-title">
                                <?=h($rot['name'])?>
                                <span style="font-size:0.75rem;color:var(--muted);">
                                    (slug: <code><?=h($rot['slug'])?></code>,
                                    url: <code>/<?=h($rot['slug'])?></code>)
                                </span>
                            </div>
                            <div class="caption" style="margin-bottom:6px;">
                                Owner: <?=h($rot['username'])?> • Mode:
                                <strong><?=h($rot['rotation_mode'])?></strong>
                            </div>

                            <!-- Mode rotasi -->
                            <form method="post" style="margin-bottom:6px;">
                                <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                                <input type="hidden" name="action" value="update_mode">
                                <input type="hidden" name="rotator_id" value="<?=$rid?>">
                                <div class="field" style="max-width:260px;">
                                    <label>Mode Rotasi</label>
                                    <select name="rotation_mode">
                                        <option value="priority" <?=$rot['rotation_mode']==='priority'?'selected':''?>>Prioritas (1→2→3)</option>
                                        <option value="random" <?=$rot['rotation_mode']==='random'?'selected':''?>>Random (domain aman & aktif)</option>
                                    </select>
                                </div>
                                <button class="btn btn-primary btn-small" type="submit">Simpan Mode</button>
                            </form>

                            <!-- Domain -->
                            <form method="post">
                                <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                                <input type="hidden" name="action" value="save_domains">
                                <input type="hidden" name="rotator_id" value="<?=$rid?>">

                                <?php for ($pos=1;$pos<=3;$pos++): 
                                    $d = $domains[$pos];
                                    ?>
                                    <div class="domain-row">
                                        <strong>Domain <?=$pos?></strong><br>
                                        <div class="field">
                                            <label>URL (tanpa http/https)</label>
                                            <input type="text" name="domain<?=$pos?>" value="<?= $d ? h($d['domain']) : '' ?>" placeholder="contoh: domain<?=$pos?>.com">
                                        </div>
                                        <div style="display:flex;gap:8px;align-items:center;">
                                            <label style="display:flex;align-items:center;gap:4px;">
                                                <input type="checkbox" name="active<?=$pos?>" value="1" <?= ($d && $d['is_active'])?'checked':''; ?>>
                                                <span style="font-size:0.75rem;">Aktif</span>
                                            </label>
                                            <?php if ($d): ?>
                                                <?php
                                                $stText='Belum dicek'; $stClass='st-unknown';
                                                if ($d['last_check_at']) {
                                                    if ($d['is_blocked']) {
                                                        $stText='Blocked';
                                                        $stClass='st-block';
                                                    } else {
                                                        $stText='Tidak terblokir';
                                                        $stClass='st-safe';
                                                    }
                                                }
                                                ?>
                                                <span class="status-pill <?=$stClass?>">
                                                    <?=$stText?>
                                                </span>
                                                <span style="font-size:0.72rem;color:var(--muted);">
                                                    <?php
                                                    if ($d['last_check_at']) {
                                                        echo h($d['last_check_at']);
                                                        if ($d['last_check_result']) {
                                                            echo ' — ' . h($d['last_check_result']);
                                                        }
                                                    } else {
                                                        echo 'Belum dicek.';
                                                    }
                                                    ?>
                                                </span>
                                                <form method="post" style="display:inline;margin-left:auto;">
                                                    <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                                                    <input type="hidden" name="action" value="check_nawala">
                                                    <input type="hidden" name="domain_id" value="<?=$d['id']?>">
                                                    <button class="btn btn-outline btn-small" type="submit">Cek Nawala</button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endfor; ?>

                                <div style="margin-top:8px;display:flex;justify-content:space-between;align-items:center;">
                                    <button class="btn btn-primary btn-small" type="submit">Simpan Domain</button>
                                    <form method="post" onsubmit="return confirm('Yakin hapus rotator ini?');">
                                        <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                                        <input type="hidden" name="action" value="delete_rotator">
                                        <input type="hidden" name="rotator_id" value="<?=$rid?>">
                                        <button class="btn btn-danger btn-small" type="submit">Hapus Rotator</button>
                                    </form>
                                </div>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>

            </div>

            <!-- KANAN: User & info -->
            <div>
                <?php if ($is_super): ?>
                    <div class="card">
                        <div class="card-title">Tambah Admin / User</div>
                        <form method="post">
                            <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                            <input type="hidden" name="action" value="add_user">
                            <div class="field">
                                <label>Username</label>
                                <input type="text" name="username" required>
                            </div>
                            <div class="field">
                                <label>Password</label>
                                <input type="password" name="password" required>
                            </div>
                            <div class="field">
                                <label>Ulangi Password</label>
                                <input type="password" name="password2" required>
                            </div>
                            <label style="display:flex;align-items:center;gap:4px;margin-bottom:6px;font-size:0.75rem;">
                                <input type="checkbox" name="is_super" value="1">
                                Jadikan Super Admin
                            </label>
                            <button class="btn btn-primary btn-small" type="submit">Tambah User</button>
                        </form>
                    </div>

                    <div class="card">
                        <div class="card-title">Detail User & Notifikasi</div>
                        <?php if (empty($all_users)): ?>
                            <p class="caption">Belum ada user.</p>
                        <?php else: ?>
                            <table>
                                <thead>
                                    <tr>
                                        <th>Username</th>
                                        <th>ID GROUP / Chat ID</th>
                                        <th>Notif</th>
                                        <th>Password</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($all_users as $u): ?>
                                    <tr>
                                        <td>
                                            <?=h($u['username'])?>
                                            <?=$u['is_super'] ? '<span style="color:#facc15;"> (super)</span>' : ''?>
                                        </td>
                                        <td>
                                            <form method="post">
                                                <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                                                <input type="hidden" name="action" value="update_user_telegram">
                                                <input type="hidden" name="user_id" value="<?=$u['id']?>">
                                                <input type="text" name="telegram_chat_id"
                                                       value="<?=h($u['telegram_chat_id'])?>"
                                                       style="width:140px;">
                                                <label style="font-size:0.72rem;margin-left:4px;">
                                                    <input type="checkbox" name="notify_enabled" value="1" <?=$u['notify_enabled']?'checked':'';?>>
                                                    Notif
                                                </label>
                                                <button class="btn btn-primary btn-small" type="submit">Simpan</button>
                                            </form>
                                        </td>
                                        <td style="text-align:center;"><?= $u['notify_enabled'] ? 'ON' : 'OFF' ?></td>
                                        <td>
                                            <form method="post">
                                                <input type="hidden" name="csrf_token" value="<?=h($csrf)?>">
                                                <input type="hidden" name="action" value="change_user_password">
                                                <input type="hidden" name="user_id" value="<?=$u['id']?>">
                                                <input type="password" name="new_password" placeholder="baru" style="width:90px;">
                                                <input type="password" name="new_password2" placeholder="ulang" style="width:90px;">
                                                <button class="btn btn-outline btn-small" type="submit">Ganti</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                            <p class="caption" style="margin-top:6px;">
                                ID GROUP bisa didapat dari bot seperti <code>@RawDataBot</code> atau sejenisnya.  
                                Contoh: <code>-4769389373</code>.
                            </p>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-title">Info</div>
                    <p class="caption">
                        • Cron <code>cron_auto_check.php</code> akan cek status Nawala semua domain aktif.<br>
                        • Rotator hanya memakai flag <b>is_blocked</b> dari database (tidak cek realtime di request).<br>
                        • Notifikasi Telegram kirim ke <b>pemilik rotator</b> yang notif-nya ON dan punya Chat ID.<br>
                        • URL rotator: <code>https://jalurvipp.site/&lt;slug&gt;</code> (diatur dari panel ini).<br>
                    </p>
                </div>

            </div>
        </div>
    <?php endif; ?>

</div>
</div>
</div>
</body>
</html>
