-- Ganti nama DB di cPanel, ini cuma struktur tabel.

CREATE TABLE rt_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password_hash VARCHAR(255) NOT NULL,
    is_super TINYINT(1) NOT NULL DEFAULT 0,
    telegram_chat_id VARCHAR(50) DEFAULT NULL,
    notify_enabled TINYINT(1) NOT NULL DEFAULT 1,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE rt_rotators (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    name VARCHAR(100) NOT NULL,
    slug VARCHAR(50) NOT NULL UNIQUE,
    rotation_mode ENUM('random','priority') NOT NULL DEFAULT 'priority',
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES rt_users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE rt_domains (
    id INT AUTO_INCREMENT PRIMARY KEY,
    rotator_id INT NOT NULL,
    position TINYINT NOT NULL, -- 1,2,3
    domain VARCHAR(255) NOT NULL,
    is_active TINYINT(1) NOT NULL DEFAULT 1,
    is_blocked TINYINT(1) NOT NULL DEFAULT 0,
    last_check_at DATETIME NULL,
    last_check_result VARCHAR(255) DEFAULT NULL,
    UNIQUE KEY uniq_rot_pos (rotator_id, position),
    FOREIGN KEY (rotator_id) REFERENCES rt_rotators(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE rt_settings_global (
    key_name VARCHAR(100) PRIMARY KEY,
    value_text TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE rt_settings_rotator (
    rotator_id INT NOT NULL,
    key_name VARCHAR(100) NOT NULL,
    value_text TEXT,
    PRIMARY KEY (rotator_id, key_name),
    FOREIGN KEY (rotator_id) REFERENCES rt_rotators(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
